@extends('admin.layouts.app')
@section('panel')
    <div id="app">
        <div class="row">

            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">

                        <div class="row justify-content-between mt-3">
                            <div class="col-md-7">
                                <ul>
                                    <li>
                                        <h5>@lang('Language Keywords of') {{ __($lang->name) }}</h5>
                                    </li>
                                </ul>
                            </div>
                            @can('admin.language.store.key')
                                <div class="col-md-5 mt-md-0 mt-3">
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#addModal" class="btn btn-sm btn-outline--primary float-end"><i class="fas fa-plus"></i> @lang('Add New Key') </button>
                                </div>
                            @endcan
                        </div>
                        <hr>
                        <div class="table-responsive--sm table-responsive">
                            <table class="table table--light tabstyle--two custom-data-table white-space-wrap" id="myTable">
                                <thead>
                                    <tr>
                                        <th>
                                            @lang('Key')
                                        </th>
                                        <th>
                                            {{ __($lang->name) }}
                                        </th>
                                        @can(['admin.language.update.key', 'admin.language.delete.key'])
                                            <th class="w-85">@lang('Action')</th>
                                        @endcan
                                    </tr>
                                </thead>
                                <tbody>

                                    @forelse($json as $k => $language)
                                        <tr>
                                            <td class="white-space-wrap">{{ $k }}</td>
                                            <td class="text-left white-space-wrap">{{ $language }}</td>

                                            @can(['admin.language.update.key', 'admin.language.delete.key'])
                                                <td>
                                                    <div class="button--group">
                                                        @can('admin.language.update.key')
                                                            <button type="button" data-bs-target="#editModal" data-bs-toggle="modal" data-title="{{ $k }}" data-key="{{ $k }}" data-value="{{ $language }}" class="editModal btn btn-sm btn-outline--primary">
                                                                <i class="la la-pencil"></i> @lang('Edit')
                                                            </button>
                                                        @endcan

                                                        @can('admin.language.delete.key')
                                                            <button type="button" data-key="{{ $k }}" data-value="{{ $language }}" data-bs-toggle="modal" data-bs-target="#DelModal" class="btn btn-sm btn-outline--danger deleteKey">
                                                                <i class="la la-trash"></i> @lang('Remove')
                                                            </button>
                                                        @endcan
                                                    </div>
                                                </td>
                                            @endcan
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @if ($json->hasPages())
                        <div class="card-footer py-4">
                            @php
                                echo paginateLinks($json);
                            @endphp
                        </div>
                    @endif
                </div>
            </div>
        </div>

        @can('admin.language.store.key')
            <div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="addModalLabel"> @lang('Add New')</h4>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <i class="las la-times"></i>
                            </button>
                        </div>

                        <form action="{{ route('admin.language.store.key', $lang->id) }}" method="post">
                            @csrf
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="key">@lang('Key')</label>
                                    <input type="text" class="form-control" id="key" name="key" value="{{ old('key') }}" required>

                                </div>
                                <div class="form-group">
                                    <label for="value">@lang('Value')</label>
                                    <input type="text" class="form-control" id="value" name="value" value="{{ old('value') }}" required>

                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn--primary w-100 h-45"> @lang('Submit')</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        @endcan

        @can('admin.language.update.key')
            <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="editModalLabel">@lang('Edit')</h4>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><i class="las la-times"></i></button>
                        </div>

                        <form action="{{ route('admin.language.update.key', $lang->id) }}" method="post">
                            @csrf
                            <div class="modal-body">
                                <div class="form-group ">
                                    <label for="inputName" class="form-title"></label>
                                    <input type="text" class="form-control" name="value" required>
                                </div>
                                <input type="hidden" name="key">
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        @endcan
        <!-- Modal for DELETE -->
        @can('admin.language.delete.key')
            <div class="modal fade" id="DelModal" tabindex="-1" role="dialog" aria-labelledby="DelModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="DelModalLabel"> @lang('Confirmation Alert!')</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><i class="las la-times"></i></button>
                        </div>
                        <div class="modal-body">
                            <p>@lang('Are you sure to delete this key from this language?')</p>
                        </div>
                        <form action="{{ route('admin.language.delete.key', $lang->id) }}" method="post">
                            @csrf
                            <input type="hidden" name="key">
                            <input type="hidden" name="value">
                            <div class="modal-footer">
                                <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('No')</button>
                                <button type="submit" class="btn btn--primary">@lang('Yes')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        @endcan
    </div>

    {{-- Import Modal --}}

    @can('admin.language.import.lang')
        <div class="modal fade" id="importModal">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">@lang('Import Keywords')</h4>
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"><i class="las la-times"></i></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Import From')</label>
                            <select class="form-control select_lang select2" data-minimum-results-for-search="-1" required>
                                <option value="">@lang('Select One')</option>
                                <option value="999">@lang('System')</option>
                                @foreach ($list_lang as $data)
                                    @if ($data->id != $lang->id)
                                        <option value="{{ $data->id }}">{{ __($data->name) }}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-bs-dismiss="modal">@lang('Close')</button>
                        <button type="button" class="btn btn--primary import_lang"> @lang('Import Now')</button>
                    </div>
                </div>
            </div>
        </div>
    @endcan
@endsection

@push('breadcrumb-plugins')
    <x-search-form placeholder="Search keywords" />
    @can('admin.language.import.lang')
        <button type="button" class="btn btn-sm btn-outline--primary importBtn"><i class="la la-download"></i>@lang('Import Keywords')</button>
    @endcan
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";
            $(document).on('click', '.deleteKey', function() {
                var modal = $('#DelModal');
                modal.find('input[name=key]').val($(this).data('key'));
                modal.find('input[name=value]').val($(this).data('value'));
            });
            $(document).on('click', '.editModal', function() {
                var modal = $('#editModal');
                modal.find('.form-title').text($(this).data('title'));
                modal.find('input[name=key]').val($(this).data('key'));
                modal.find('input[name=value]').val($(this).data('value'));
            });


            $(document).on('click', '.importBtn', function() {
                $('#importModal').modal('show');
            });
            $(document).on('click', '.import_lang', function(e) {
                var id = $('.select_lang').val();

                if (id == '') {
                    notify('error', 'Invalide selection');

                    return 0;
                } else {
                    $.ajax({
                        type: "post",
                        url: "{{ route('admin.language.import.lang') }}",
                        data: {
                            id: id,
                            toLangid: "{{ $lang->id }}",
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(data) {
                            if (data == 'success') {
                                notify('success', 'Import Data Successfully');
                                window.location.href = "{{ url()->current() }}"
                            }
                        }
                    });
                }

            });
        })(jQuery);
    </script>
@endpush
